#!/bin/sh

[ -f /usr/voltaire/common.sh ] && . /usr/voltaire/common.sh

if [ $(basename $0) = "uninstall.sh" ] ; then
	# Copy original uninstall
        cp $0 /tmp/gs-uninstall-$$.sh
        exec /tmp/gs-uninstall-$$.sh
fi

script_dir=$(dirname $0)
script_dir=$(cd $script_dir;pwd)


K_VER=$(uname -r)

remove_pkg()
{
	PKG=$(rpm -qa|grep $1)
	if [ ! -z $PKG ] ; then 
		if [ $? -eq 0 ] ; then
			rpm -e $PKG
		fi
		if [ $? -ne 0 ] ; then
			echo Failed to remove $PKG
			exit 1
		fi
	fi
}

usage()
{
	echo $(basename $0) [--force]
} 

force=0
while [[ ! -z "$1" ]]
do
	case $1 in
	--force)
		force=1
		GSPackageType=unknown
		shift
		;;
	--help|-h)
		usage
		exit
		;;
	*)
		echo "Unknown option $1"
		exit
		;;
	esac
done


if [ -f /usr/voltaire/version ]
then
	source /usr/voltaire/version
else
	if [ $force -eq 0 ]
	then
		echo "ERROR: version file is missing"
		exit 1
	else
		echo "WARNING: removing GridStack by force"
	fi
fi

# stop gridstack only if loaded
[ -x /etc/init.d/gridstack ] && \
	! /etc/init.d/gridstack status | grep -q 'not loaded' && \
	/etc/init.d/gridstack stop

# restore network scripts
if [ $linux_dist = suse ] 
then
	if [ -f /usr/voltaire/functions-ib.diff ] ; then
		if ( patch --forward --dry-run -p1 -R -d /etc/sysconfig/network/scripts/ < /usr/voltaire/functions-ib.diff &> /dev/null) ; then
			patch  -p1 -R -d /etc/sysconfig/network/scripts/ < /usr/voltaire/functions-ib.diff
		fi
	fi
		
elif [ $linux_dist = redhat ]
then
	grep -v "ifup-pre-ib" /sbin/ifup-pre-local > /tmp/ifup-pre-local
	mv /tmp/ifup-pre-local /sbin/ifup-pre-local
	grep -v "ifdown-post-ib" /sbin/ifdown-pre-local > /tmp/ifdown-pre-local
	mv /tmp/ifdown-pre-local /sbin/ifdown-pre-local
fi

# remove RPM's
remove_pkg ib-his
remove_pkg ib-enhanced-services
remove_pkg vltmpi-OPENIB

# remove ofed if installed by GridStack
if [ "X$GSPackageType" == "Xfull" ]
then
	if rpm -q ofed-scripts >/dev/null
	then
		ofed_uninstall=$(rpm -ql ofed-scripts | grep uninstall)
	else
		ofed_uninstall=""
	fi
	
	if [ ! -z $ofed_uninstall ]
	then		
		yes | $ofed_uninstall
	else
		echo "WARNING: Will not uninstall OFED - uninstall utility is missing"
	fi

	grep -v "alias net-pf-27           ib_sdp" /etc/modprobe.conf > /tmp/modprobe.conf
	cp /tmp/modprobe.conf /etc/modprobe.conf
	grep -v "options ib_local_sa cache_timeout" /etc/modprobe.conf > /tmp/modprobe.conf
	cp /tmp/modprobe.conf /etc/modprobe.conf

	if [ -f /lib/modules/$K_VER/source/Module.symvers ]
	then
		MOD_SYMVERS_KERNEL=/lib/modules/$K_VER/source/Module.symvers
	elif [ -f /lib/modules/$K_VER/build/Module.symvers ]
	then
		MOD_SYMVERS_KERNEL=/lib/modules/$K_VER/build/Module.symvers
	else
		echo file Module.symvers not found
	fi
	
	if [ ! -z $MOD_SYMVERS_KERNEL ]
	then
		MOD_SYMVERS_PATCH=/usr/voltaire/backup/Module.symvers.patch
		if [ -f $MOD_SYMVERS_PATCH ]
		then
			patch -R -d $(dirname $MOD_SYMVERS_KERNEL)  < $MOD_SYMVERS_PATCH
		fi
	fi
fi
remove_pkg gridstack-scripts

rm -rf /usr/voltaire


